-- RaidPointsClient v0.43
--
-- A client for the RaidPoints addon
--
-- coded 2005/2006 by Rene Schneider (Slarti on Blackhand)

rpc_chars={};
rpc_charsbg={};
rpcmf_buffer={};
rpcmf_startpos=1;
rpcmf_orderby="name";
rpcmf_orderdirection="ASC";
rpc_status=RPC_JOINED;
rpc_servername="";
rpc_server_timeout=0;
rpc_pingcounter=0;
rpc_time=0;
rpccf_currentcharname="";
rpc_transactions={};
rpc_detailsrequested="";
rpc_detailsrecording=0;

-- core functions

function RPC_OnLoad()
	SLASH_RPC1 = "/rpc";
	SlashCmdList["RPC"] = RPC_Command;
	RPC_DisplayMessage(RPC_ONLOAD);
	this:RegisterEvent("CHAT_MSG_ADDON");
end

function RPCDB_AddCharacter(charname)
	if(rpc_chars[charname]~=nil) then
		return RPC_ERROR_CHAR_EXISTS;
	end
	rpc_chars[charname]={points=0,oldpoints=0,class=0};
	return RPC_SUCCESS;
end

function RPCDB_ClearRaidSet()
	rpc_chars={};
end

function RPC_Command(cmd)
	parts={};
	partcount=0;
	for w in string.gmatch(cmd, "%S+") do
    		parts[partcount]=w;
	    	partcount=partcount+1;
	end
	if(partcount==0) then
	    	RPCMF_Toggle();
    		return;
	end
	RPC_DisplayMessage(RPCCONSOLE_COMMAND_UNKNOWN);
end

function RPC_AdvanceTime(arg1)
	rpc_time=rpc_time+arg1;
	if rpc_time >= 10.0 then
		rpc_time = 0;
		RPC_Ping();
	end
end

-- general utility functions

function RPC_DisplayMessage(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end

function RPC_Round(number,decimals)
	return math.floor((number*math.pow(10,decimals)+0.5))/math.pow(10,decimals);
end

function RPC_SendChatMessage(msg)
	SendAddonMessage("RPCmessage", msg, "RAID");
end

-- RaidPointsClient GUI functions

function RPCMF_Toggle()
	if(RPCMainFrame:IsVisible()) then
		RPCMF_Hide();
	else
		RPCMF_Show();
	end
end

function RPCMF_Show()
	if(not RPCMainFrame:IsVisible()) then
		ShowUIPanel(RPCMainFrame);
	end
end

function RPCMF_Hide()
	if(RPCMainFrame:IsVisible()) then
		HideUIPanel(RPCMainFrame);
	end
end

function RPCMF_SetColumnWidth(width, frame)
	if not frame then
    	frame = this;
	end
	frame:SetWidth(width);
  	getglobal(frame:GetName().."Middle"):SetWidth(width - 9);
end

function RPCMF_OnShow()
	RPCMF_Update();
end

function RPCMF_CreateBuffer()
	rpcmf_buffer={};
	table.foreach(rpc_chars,RPCMF_AddToBuffer);
end

function RPCMF_AddToBuffer(key,entry)
	table.insert(rpcmf_buffer,{points=entry.points,oldpoints=entry.oldpoints,name=key,class=entry.class});
	return nil;
end

function RPCMF_CompareName_ASC(i,j)
	return string.lower(i.name) < string.lower(j.name);
end

function RPCMF_CompareName_DESC(i,j)
	return string.lower(i.name) > string.lower(j.name);
end

function RPCMF_CompareClass_ASC(i,j)
	return i.class < j.class;
end

function RPCMF_CompareClass_DESC(i,j)
	return i.class > j.class;
end

function RPCMF_CompareDifPoints_ASC(i,j)
	return i.points < j.points;
end

function RPCMF_CompareDifPoints_DESC(i,j)
	return i.points > j.points;
end

function RPCMF_CompareOldPoints_ASC(i,j)
	return i.oldpoints < j.oldpoints;
end

function RPCMF_CompareOldPoints_DESC(i,j)
	return i.oldpoints > j.oldpoints;
end

function RPCMF_CompareCurPoints_ASC(i,j)
	return (i.points-i.oldpoints) < (j.points-j.oldpoints);
end

function RPCMF_CompareCurPoints_DESC(i,j)
	return (i.points-i.oldpoints) > (j.points-j.oldpoints);
end

function RPCMF_SortBuffer()
	if(rpcmf_orderby=="name") then
		if(rpcmf_orderdirection=="ASC") then
			table.sort(rpcmf_buffer,RPCMF_CompareName_ASC);
		else
			table.sort(rpcmf_buffer,RPCMF_CompareName_DESC);
		end
	end
	if(rpcmf_orderby=="class") then
		if(rpcmf_orderdirection=="ASC") then
			table.sort(rpcmf_buffer,RPCMF_CompareClass_ASC);
		else
			table.sort(rpcmf_buffer,RPCMF_CompareClass_DESC);
		end
	end
	if(rpcmf_orderby=="curpoints") then
		if(rpcmf_orderdirection=="ASC") then
			table.sort(rpcmf_buffer,RPCMF_CompareCurPoints_ASC);
		else
			table.sort(rpcmf_buffer,RPCMF_CompareCurPoints_DESC);
		end
	end
	if(rpcmf_orderby=="oldpoints") then
		if(rpcmf_orderdirection=="ASC") then
			table.sort(rpcmf_buffer,RPCMF_CompareOldPoints_ASC);
		else
			table.sort(rpcmf_buffer,RPCMF_CompareOldPoints_DESC);
		end
	end
	if(rpcmf_orderby=="difpoints") then
		if(rpcmf_orderdirection=="ASC") then
			table.sort(rpcmf_buffer,RPCMF_CompareDifPoints_ASC);
		else
			table.sort(rpcmf_buffer,RPCMF_CompareDifPoints_DESC);
		end
	end
end

function RPCMF_ReSort(key)
	if(key==rpcmf_orderby) then
		if(rpcmf_orderdirection=="ASC") then
			rpcmf_orderdirection="DESC";
		else
			rpcmf_orderdirection="ASC";
		end
	else
		rpcmf_orderdirection="ASC";
		rpcmf_orderby=key;
	end
	RPCMF_Update();
end

function RPCMF_Update()
	RPCMF_CreateBuffer();
	RPCMF_SortBuffer();
	local startpos=FauxScrollFrame_GetOffset(RPCMainScrollFrame)+1;
	rpcmf_startpos=startpos;
	local endpos=startpos+14;
	if(endpos>getn(rpcmf_buffer)) then
		endpos=getn(rpcmf_buffer);
	end
	for n=startpos,endpos,1 do
		item=getglobal("RPCMainChar"..(n-startpos+1).."Name");
		item:SetText(rpcmf_buffer[n].name);
		item:SetTextColor(RPC_GetColorForClass(rpcmf_buffer[n].class));
		item:Show();
		local points_old=rpcmf_buffer[n].oldpoints;
		local points_cur=rpcmf_buffer[n].points+points_old;
		item=getglobal("RPCMainChar"..(n-startpos+1).."PointsCur");
		item:SetText(points_cur);
		if(points_cur>=0) then
			getglobal("RPCMainChar"..(n-startpos+1).."PointsCurText"):SetTextColor(0,1,0);
		else
			getglobal("RPCMainChar"..(n-startpos+1).."PointsCurText"):SetTextColor(1,0,0);
		end
		item:Show();
		item:Disable();
		item=getglobal("RPCMainChar"..(n-startpos+1).."PointsOld");
		item:SetText(points_old);
		if(points_old>=0) then
			getglobal("RPCMainChar"..(n-startpos+1).."PointsOldText"):SetTextColor(0,1,0);
		else
			getglobal("RPCMainChar"..(n-startpos+1).."PointsOldText"):SetTextColor(1,0,0);
		end
		item:Show();
		item:Disable();
		item=getglobal("RPCMainChar"..(n-startpos+1).."PointsDif");
		item:SetText(points_cur-points_old);
		if(points_cur-points_old>=0) then
			getglobal("RPCMainChar"..(n-startpos+1).."PointsDifText"):SetTextColor(0,1,0);
		else
			getglobal("RPCMainChar"..(n-startpos+1).."PointsDifText"):SetTextColor(1,0,0);
		end
		item:Show();
		item:Disable();
	end
	for n=(endpos-startpos+2),15,1 do
		item=getglobal("RPCMainChar"..n.."Select");
		if(item~=nil) then item:Hide(); end
		item=getglobal("RPCMainChar"..n.."MobRP");
		if(item~=nil) then item:Hide(); end
		item=getglobal("RPCMainChar"..n.."ExtraRP");
		if(item~=nil) then item:Hide(); end
		item=getglobal("RPCMainChar"..n.."Name");
		if(item~=nil) then item:Hide(); end
		item=getglobal("RPCMainChar"..n.."PointsCur");
		if(item~=nil) then item:Hide(); end
		item=getglobal("RPCMainChar"..n.."PointsOld");
		if(item~=nil) then item:Hide(); end
		item=getglobal("RPCMainChar"..n.."PointsDif");
		if(item~=nil) then item:Hide(); end
	end
	if(rpc_chars[UnitName("player")]~=nil) then
		RPCPoints:SetText(RPCMAIN_POINTS..(rpc_chars[UnitName("player")].points+rpc_chars[UnitName("player")].oldpoints).." RP.");
	else
		RPCPoints:SetText("");
	end
	FauxScrollFrame_Update(RPCMainScrollFrame, getn(rpcmf_buffer)-1, 14, 15);
	RPCMF_StatusUpdate();
end

function RPCMF_StatusUpdate()
	if(rpc_status==RPC_DISCONNECTED) then
		RPCStatus:SetText(RPCSTATUS_DISCONNECTED);
		RPCStatus:SetTextColor(1,0,0);
	end
	if(rpc_status==RPC_JOINED) then
		RPCStatus:SetText(RPCSTATUS_JOINED);
		RPCStatus:SetTextColor(1,0.76,0);
	end
	if(rpc_status==RPC_CONNECTED) then
		RPCStatus:SetText(RPCSTATUS_CONNECTED..rpc_servername);
		RPCStatus:SetTextColor(0,1,0);
	end
end

function RPC_GetColorForClass(class)
	if(class==1) then return 1.0, 0.49, 0.04; end
	if(class==2) then return 0.67, 0.83, 0.45; end
	if(class==3) then return 0.41, 0.8, 0.94; end
	if(class==4) then return 0.96, 0.55, 0.73; end
	if(class==5) then return 1.0, 1.0, 1.0; end
	if(class==6) then return 1.0, 0.96, 0.41; end
	if(class==7) then return 0.14, 0.35, 1.0; end
	if(class==8) then return 0.58, 0.51, 0.79; end
	if(class==9) then return 0.78, 0.61, 0.43; end
	if(class==10) then return 0.77, 0.12, 0.23; end
end

function RPC_DisConnect()
	if(rpc_status==RPC_DISCONNECTED) then
		rpc_status=RPC_JOINED;
		this:SetText(RPC_DISCONNECT);
	else
		rpc_status=RPC_DISCONNECTED;
		HideUIPanel(RPCTimerFrame);
		this:SetText(RPC_CONNECT);
	end
	RPCMF_StatusUpdate();
end

function RPC_Ping()
	if(rpc_status==RPC_DISCONNECTED or rpc_status==RPC_JOINED) then
		return;
	end
	if(rpc_pingcounter>=2) then
		RPC_SendChatMessage("Client!");
		rpc_pingcounter=0;
	else
		rpc_pingcounter=rpc_pingcounter+1;
	end
	rpc_server_timeout=rpc_server_timeout+1;
	if(rpc_server_timeout>2) then
		rpc_status=RPC_JOINED;
		RPCMF_StatusUpdate();
		return;
	end
end

function RPC_OnEvent(msg,sender)
	if(event=="CHAT_MSG_ADDON" and arg1=="RPCmessage") then
		local msg=arg2;
		local sender=arg4;
		if(msg=="Server!") then
			if(rpc_status==RPC_JOINED) then
				rpc_status=RPC_CONNECTED;
				rpc_servername=sender;
				RPCMF_StatusUpdate();
				ShowUIPanel(RPCTimerFrame);
				RPC_SendChatMessage("Request!");
			end
			rpc_server_timeout=0;
		end
		if(msg=="Clear!" and sender==rpc_servername) then
			rpc_charsbg={};
		end
		if(strsub(msg,1,5)=="Char:" and sender==rpc_servername) then
			local charname;
			local points;
			local oldpoints;
			for charname,p,oldp,cl in string.gmatch(msg,"Char:(%S+) (%S+) (%S+) (%S+)") do
				rpc_charsbg[charname]={points=tonumber(p),oldpoints=tonumber(oldp),class=tonumber(cl)};
			end
		end
		if(msg=="Commit!" and sender==rpc_servername) then
			rpc_chars=rpc_charsbg;
			if(RPCMainFrame:IsVisible()) then RPCMF_Update(); end
		end
		if(strsub(msg,1,6)=="Event:" and sender==rpc_servername) then
			for charname,txt in string.gmatch(msg,"Event:(.-):(.+)") do
				if(charname==UnitName("player")) then RPC_DisplayMessage(txt); end
			end
		end
		if(strsub(msg,1,13)=="DetailsStart:" and sender==rpc_servername) then
			local charname=strsub(msg,14);
			if(charname==rpc_detailsrequested) then
				rpc_detailsrecording=1;
				rpc_detailsrequested="";
				rpc_transactions={};
			end
		end
		if(strsub(msg,1,8)=="Details:" and sender==rpc_servername) then
			if(rpc_detailsrecording>0) then
				for count,subject,points in string.gmatch(msg,"Details:([^#]+)#([^#]+)#([^#]+)") do
					rpc_transactions[rpc_detailsrecording]={p=tonumber(points),c=tonumber(count),s=subject};
					rpc_detailsrecording=rpc_detailsrecording+1;
				end
			end
		end
		if(msg=="DetailsCommit!" and sender==rpc_servername) then
			rpc_detailsrecording=0;
			rpc_detailsrequested="";
			if(RPCCharFrame:IsVisible()) then
				RPCCF_Update();
			end
		end
	end
end

function RPCMF_CharButton_OnClick()
	local number=string.gmatch(this:GetName(),"%d+");
	local charname=rpcmf_buffer[rpcmf_startpos+number()-1].name;
	if(rpc_status==RPC_CONNECTED) then
		RPCCF_DisplayCharFrame(charname);
	end
end

function RPCCF_DisplayCharFrame(charname)
	if(RPCCharFrame:IsVisible() and rpccf_currentcharname==charname) then
		RPCCharFrame:Hide();
	else
		RPCCharFrame:Hide();
		RPCCharFrame:Show();
		RPCCharFrame:SetPoint("TOPLEFT", "RPCMainFrame", "TOPLEFT", 180, -10);
		RPCCharFrameTitleText:SetText(charname..RPCCHARFRAME_TITLE);
		RPCCharFrameColumnHeader1:Disable();
		RPCCharFrameColumnHeader2:Disable();
		RPCCharFrameColumnHeader3:Disable();
		RPCCF_Clear();
		local item=getglobal("RPCCFTransaction5Subject");
		item:SetText("Daten werden angefordert...");
		item:Show();
		rpccf_currentcharname=charname;
		RPC_RequestDetails(charname);
	end
end

function RPC_RequestDetails(username)
	rpc_detailsrequested=username;
	RPC_SendChatMessage("RequestDetails:"..username);
end

function RPCCF_Clear()
	for i=1,20,1 do
		local item=getglobal("RPCCFTransaction"..i.."Count");
		item:Disable();
		item:Hide();
		item=getglobal("RPCCFTransaction"..i.."Subject");
		item:Disable();
		item:Hide();
		item=getglobal("RPCCFTransaction"..i.."Points");
		item:Disable();
		item:Hide();
	end
end

function RPCCF_Update()
	local count=getn(rpc_transactions);
	if(count>20) then count=20; end
	RPCCF_Clear();
	for i=1,count,1 do
		local item=getglobal("RPCCFTransaction"..i.."Count");
		item:SetText(rpc_transactions[i].c.."x");
		item:Show();
		item=getglobal("RPCCFTransaction"..i.."Subject");
		item:SetText(rpc_transactions[i].s);
		item:Show();
		item=getglobal("RPCCFTransaction"..i.."Points");
		if(rpc_transactions[i].c==1) then
			item:SetText(rpc_transactions[i].p.." RP");
		else
			item:SetText(rpc_transactions[i].p.." ("..(rpc_transactions[i].p*rpc_transactions[i].c)..") RP");
		end
		if(rpc_transactions[i].p>=0) then
			item:SetDisabledTextColor(0,1,0);
		else
			item:SetDisabledTextColor(1,0,0);
		end
		item:Show();
	end
end